<?php
/**
 *
 * Ada  payment plugin
 *
 * @author Ada
 * @version 1.1.0
 * @package VirtueMart
 * @subpackage payment
 * Copyright (C) 2019 - 2020 Virtuemart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */

defined('_JEXEC') or die('Restricted access');

class AdaClient
{

    protected $secretKey = '';
    public $apiEndPoint = '';


    public function __construct($secretKey,$apiEndPoint)
    {
        
        $this->secretKey = $secretKey;
        $this->apiEndPoint = $apiEndPoint;
    }

    protected function getApiUrl($commandUrl)
    {
     
        return trim($this->apiEndPoint, '/') . '/' . $commandUrl;
    }

    public function getBalances($currency)
    {
        return $this->apiCall('balances', array('currency' => $currency));
    }

    public function getShopInfo()
    {
        return $this->apiCall('shops');
    }

    public function getCurrencies($source_currency = 'USD')
    {
    
        $currencies = $this->guestApiCall("currencies/$source_currency");
        return array_filter($currencies['data'], function ($currency) {
            return $currency['hidden'] == 0;
        });
    }

    public function createTransaction($req)
    {
       
        return $this->apiCall('payment-request',$req);
    }


    /**
     * Creates a withdrawal from your account to a specified address.<br />
     * @param amount The amount of the transaction (floating point to 8 decimals).
     * @param currency The cryptocurrency to withdraw.
     * @param address The address to send the coins to.
     * @param auto_confirm If auto_confirm is TRUE, then the withdrawal will be performed without an email confirmation.
     */
    public function createWithdrawal($amount, $currency, $address)
    {
        $req = array(
            'currency' => $currency,
            'amount' => $amount,
            'to' => $address,
            'type' => 'cash_out',
        );
        return $this->apiCall('operations/withdraw', $req);
    }

    /**
     * Creates a withdrawal from your account to a specified address.<br />
     * @param payments array of addresses and amounts.
     * @param currency The cryptocurrency to withdraw.
     */
    public function createMassWithdrawal($payments, $currency)
    {
        $req = array(
            'currency' => $currency,
            'amount' => implode(',', array_values($payments)),
            'to' => implode(',', array_keys($payments)),
            'type' => 'mass_cash_out',
        );
        return $this->apiCall('operations/withdraw', $req);
    }


    private function isSetup()
    {
    
        return !empty($this->secretKey);
    }

    protected function getCurlOptions($url,$req)
    {
    
        return [
            
          
                  CURLOPT_URL => $url,
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => "",
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 30,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => "PUT",
                  CURLOPT_POSTFIELDS => json_encode($req),
                  //curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($req)),
                  // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
                  // CURLOPT_HTTPHEADER => [
                  //   "Authorization: Bearer PKFKoEM0VSlmmlKlXuYd5wgfYRyLthajQajGr7w6OXhqPoPbCQ ",
                  // ],
                  CURLOPT_HTTPHEADER => [
                    "Authorization:Bearer ".$this->secretKey,
                    "Content-Type: application/json"
                  ],
        ];

    }

    private function apiCall($cmd, $req = array())
    {
        if (!$this->isSetup()) {
           
            return array('error' => 'Please check Your API KEY or URL !');
        }

       
        return $this->guestApiCall($cmd, $req);
    }

    private function guestApiCall($cmd, $req = array())
    {

        // Generate the query string
        $queryString = '';
        // if (!empty($this->secretKey)) {
        //     $req['api_key'] = $this->secretKey;
        // }
        // if (!empty($req)) {
        //     $post_data = http_build_query($req, '', '&');
        //     $queryString = '?' . $post_data;
        // }

        try {
             //$apiUrl = $this->getApiUrl($cmd . $queryString);
            $apiUrl = $this->getApiUrl($cmd);


            $ch = curl_init();
            curl_setopt_array($ch, $this->getCurlOptions($apiUrl,$req));
            $data = curl_exec($ch);

            if ($data !== FALSE) {

                // $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
                // $body = substr($data, $header_size);
                $dec = $this->jsonDecode($data);

                if ($dec !== NULL && count($dec)) {
                    return $dec;
                } else {
                    // If you are using PHP 5.5.0 or higher you can use json_last_error_msg() for a better error message
                    return array('status' => 'error', 'message' => 'Unable to parse JSON result (' . json_last_error() . ')');
                }
            } else {
                return array('status' => 'error', 'message' => 'cURL error: ' . curl_error($ch));
            }
        } catch (\Exception $e) {
            return array('status' => 'error', 'message' => 'Could not send request to API : ' . $apiUrl);
        }
    }

    private function jsonDecode($data)
    {
        if (PHP_INT_SIZE < 8 && version_compare(PHP_VERSION, '5.4.0') >= 0) {
            // We are on 32-bit PHP, so use the bigint as string option. If you are using any API calls with Satoshis it is highly NOT recommended to use 32-bit PHP
            $dec = json_decode($data, TRUE, 512, JSON_BIGINT_AS_STRING);
        } else {
            $dec = json_decode($data, TRUE);
        }
        return $dec;
    }
}
